#include "common/States11.hlsl"
#include "common/samplers11.hlsl"
#include "common/context.hlsl"
#include "common/AmbientCube.hlsl"
#include "common/cloudsColor.hlsl"
#include "common/random.hlsl"

#include "ParticleSystem2/common/basis.hlsl"

Texture2D tex;

float3 wPos;
float4 diffuseColor;
float2 scale;//scale, scaleDistFactor

static const float opacityMax = 0.7;

static const float4 quad[4] = {
	float4( -0.5, -0.5, 0, 0),
	float4( -0.5,  0.5, 0, 0),
	float4(  0.5, -0.5, 0, 0),
	float4(  0.5,  0.5, 0, 0)
};

struct PS_INPUT
{
	float4 pos: SV_POSITION;
	float3 uv : TEXCOORD0;
};

PS_INPUT vsGlow(uint vertId:  SV_VertexID)
{
	PS_INPUT o;
	float rnd = frac(sin(gModelTime*321513.5123));
	float4 vPos = quad[vertId];

	o.pos = mul(float4(wPos,1), gView);	
	float scaleFactor = scale.x * (1 + scale.y * max(0, o.pos.z));
	o.pos += vPos * scaleFactor * (5 + rnd);
	o.pos = mul(o.pos, gProj);

	float ang = smoothNoise1(gModelTime*10+rnd*0.1)*6.2832;
	o.uv.xy = mul(vPos.xy, rotMatrix2x2(ang)) + 0.5;
	o.uv.z = opacityMax*(0.9 + 0.1*rnd);
	return o;
}

float4 psGlow(PS_INPUT i, uniform bool bClouds): SV_TARGET0
{
	float4 alpha = tex.Sample(ClampLinearSampler, i.uv.xy).rrrr;

	float4 color = diffuseColor * diffuseColor * alpha * i.uv.z;
	color.rgb *= 1.0 + 1 * pow(max(0, gSunDir.y), 0.5);
	
	if(bClouds)
		color *= 1-sbCloudsColor[cloudColorId.x].a;
	
	return color;
}

technique10 flareGlowTech
{
	pass p0
	{
		DISABLE_CULLING;
		ENABLE_RO_DEPTH_BUFFER;
		SetBlendState(additiveAlphaBlend, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
		
		SetVertexShader(CompileShader(vs_4_0, vsGlow()));
		SetHullShader(NULL);
		SetDomainShader(NULL);
		SetGeometryShader(NULL);
		SetComputeShader(NULL);
		SetPixelShader(CompileShader(ps_4_0, psGlow(false))); 
	}
	
	pass withClouds
	{
		DISABLE_CULLING;
		ENABLE_RO_DEPTH_BUFFER;
		SetBlendState(additiveAlphaBlend, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
		
		SetVertexShader(CompileShader(vs_4_0, vsGlow()));
		SetHullShader(NULL);
		SetDomainShader(NULL);
		SetGeometryShader(NULL);
		SetComputeShader(NULL);
		SetPixelShader(CompileShader(ps_4_0, psGlow(true))); 
	}
}

